/*
 * Decompiled with CFR 0.152.
 */
package carpet.script;

import carpet.CarpetServer;
import carpet.CarpetSettings;
import carpet.fakes.CommandDispatcherInterface;
import carpet.script.CarpetEventServer;
import carpet.script.CarpetScriptHost;
import carpet.script.Module;
import carpet.script.ScriptServer;
import carpet.script.annotation.AnnotationParser;
import carpet.script.api.Auxiliary;
import carpet.script.api.BlockIterators;
import carpet.script.api.Entities;
import carpet.script.api.Inventories;
import carpet.script.api.Scoreboards;
import carpet.script.api.WorldAccess;
import carpet.script.exception.ExpressionException;
import carpet.script.exception.LoadException;
import carpet.script.language.Arithmetic;
import carpet.script.language.ControlFlow;
import carpet.script.language.DataStructures;
import carpet.script.language.Functions;
import carpet.script.language.Loops;
import carpet.script.language.Sys;
import carpet.script.language.Threading;
import carpet.script.utils.AppStoreManager;
import carpet.script.value.FunctionValue;
import carpet.utils.CarpetProfiler;
import carpet.utils.CommandHelper;
import carpet.utils.Messenger;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarpetScriptServer
extends ScriptServer {
    public static final Logger LOG = LoggerFactory.getLogger((String)"Scarpet");
    public final MinecraftServer server;
    public CarpetScriptHost globalHost;
    public Map<String, CarpetScriptHost> modules;
    public Set<String> unloadableModules;
    public long tickStart;
    public boolean stopAll;
    public int tickDepth;
    private Set<String> holyMoly;
    public CarpetEventServer events;
    private static final List<Module> bundledModuleData = new ArrayList<Module>();
    private static final List<Module> ruleModuleData = new ArrayList<Module>();

    public static void registerBuiltInApp(Module app) {
        bundledModuleData.add(app);
    }

    public static void registerSettingsApp(Module app) {
        ruleModuleData.add(app);
    }

    public CarpetScriptServer(MinecraftServer server) {
        this.server = server;
        this.init();
    }

    private void init() {
        this.events = new CarpetEventServer(this);
        this.modules = new HashMap<String, CarpetScriptHost>();
        this.unloadableModules = new HashSet<String>();
        this.tickStart = 0L;
        this.stopAll = false;
        this.holyMoly = this.server.method_3734().method_9235().getRoot().getChildren().stream().map(CommandNode::getName).collect(Collectors.toSet());
        this.globalHost = CarpetScriptHost.create(this, null, false, null, p -> true, false, null);
    }

    public void initializeForWorld() {
        CarpetServer.settingsManager.initializeScarpetRules();
        CarpetServer.extensions.forEach(e -> {
            if (e.extensionSettingsManager() != null) {
                e.extensionSettingsManager().initializeScarpetRules();
            }
        });
        if (CarpetSettings.scriptsAutoload) {
            for (String moduleName : this.listAvailableModules(false)) {
                this.addScriptHost(this.server.method_3739(), moduleName, null, true, true, false, null);
            }
        }
        CarpetEventServer.Event.START.onTick();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Module getModule(String name, boolean allowLibraries) {
        block20: {
            try {
                Path folder = this.server.method_27050(class_5218.field_24188).resolve("scripts");
                if (!Files.exists(folder, new LinkOption[0])) {
                    Files.createDirectories(folder, new FileAttribute[0]);
                }
                try (Stream<Path> folderLister = Files.list(folder);){
                    Optional<Path> scriptPath = folderLister.filter(script -> script.getFileName().toString().equalsIgnoreCase(name + ".sc") || allowLibraries && script.getFileName().toString().equalsIgnoreCase(name + ".scl")).findFirst();
                    if (scriptPath.isPresent()) {
                        Module module2 = Module.fromPath(scriptPath.get());
                        return module2;
                    }
                }
                if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) break block20;
                Path globalFolder = FabricLoader.getInstance().getConfigDir().resolve("carpet/scripts");
                if (!Files.exists(globalFolder, new LinkOption[0])) {
                    Files.createDirectories(globalFolder, new FileAttribute[0]);
                }
                try (Stream<Path> folderWalker = Files.walk(globalFolder, new FileVisitOption[0]);){
                    Optional<Path> scriptPath = folderWalker.filter(script -> script.getFileName().toString().equalsIgnoreCase(name + ".sc") || allowLibraries && script.getFileName().toString().equalsIgnoreCase(name + ".scl")).findFirst();
                    if (scriptPath.isPresent()) {
                        Module module = Module.fromPath(scriptPath.get());
                        return module;
                    }
                }
            }
            catch (IOException e) {
                CarpetSettings.LOG.error("Exception while loading the app: ", (Throwable)e);
            }
        }
        for (Module moduleData : bundledModuleData) {
            if (!moduleData.name().equalsIgnoreCase(name) || !allowLibraries && moduleData.library()) continue;
            return moduleData;
        }
        return null;
    }

    public Module getRuleModule(String name) {
        for (Module moduleData : ruleModuleData) {
            if (!moduleData.name().equalsIgnoreCase(name)) continue;
            return moduleData;
        }
        return null;
    }

    public List<String> listAvailableModules(boolean includeBuiltIns) {
        ArrayList<String> moduleNames;
        block19: {
            moduleNames = new ArrayList<String>();
            if (includeBuiltIns) {
                for (Module mi : bundledModuleData) {
                    if (mi.library() || mi.name().endsWith("_beta")) continue;
                    moduleNames.add(mi.name());
                }
            }
            try {
                Path worldScripts = this.server.method_27050(class_5218.field_24188).resolve("scripts");
                if (!Files.exists(worldScripts, new LinkOption[0])) {
                    Files.createDirectories(worldScripts, new FileAttribute[0]);
                }
                try (Stream<Path> folderLister = Files.list(worldScripts);){
                    folderLister.filter(f -> f.toString().endsWith(".sc")).forEach(f -> moduleNames.add(f.getFileName().toString().replaceFirst("\\.sc$", "").toLowerCase(Locale.ROOT)));
                }
                if (!includeBuiltIns || FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) break block19;
                Path globalScripts = FabricLoader.getInstance().getConfigDir().resolve("carpet/scripts");
                if (!Files.exists(globalScripts, new LinkOption[0])) {
                    Files.createDirectories(globalScripts, new FileAttribute[0]);
                }
                try (Stream<Path> folderWalker = Files.walk(globalScripts, FileVisitOption.FOLLOW_LINKS);){
                    folderWalker.filter(f -> f.toString().endsWith(".sc")).forEach(f -> moduleNames.add(f.getFileName().toString().replaceFirst("\\.sc$", "").toLowerCase(Locale.ROOT)));
                }
            }
            catch (IOException e) {
                CarpetSettings.LOG.error("Exception while searching for apps: ", (Throwable)e);
            }
        }
        return moduleNames;
    }

    public CarpetScriptHost getAppHostByName(String name) {
        if (name == null) {
            return this.globalHost;
        }
        return this.modules.get(name);
    }

    public boolean addScriptHost(class_2168 source, String name, Predicate<class_2168> commandValidator, boolean perPlayer, boolean autoload, boolean isRuleApp, AppStoreManager.StoreNode installer) {
        CarpetScriptHost newHost;
        Module module;
        CarpetProfiler.ProfilerToken currentSection = CarpetProfiler.start_section(null, "Scarpet load", CarpetProfiler.TYPE.GENERAL);
        if (commandValidator == null) {
            commandValidator = p -> true;
        }
        long start = System.nanoTime();
        name = name.toLowerCase(Locale.ROOT);
        boolean reload = false;
        if (this.modules.containsKey(name)) {
            if (isRuleApp) {
                return false;
            }
            this.removeScriptHost(source, name, false, isRuleApp);
            reload = true;
        }
        Module module2 = module = isRuleApp ? this.getRuleModule(name) : this.getModule(name, false);
        if (module == null) {
            Messenger.m(source, "r Failed to add " + name + " app: App not found");
            return false;
        }
        try {
            newHost = CarpetScriptHost.create(this, module, perPlayer, source, commandValidator, isRuleApp, installer);
        }
        catch (LoadException e) {
            Messenger.m(source, "r Failed to add " + name + " app" + (String)(e.getMessage() == null ? "" : ": " + e.getMessage()));
            return false;
        }
        this.modules.put(name, newHost);
        if (!isRuleApp) {
            this.unloadableModules.add(name);
        }
        if (autoload && !newHost.persistenceRequired) {
            this.removeScriptHost(source, name, false, false);
            return false;
        }
        String action = installer != null ? (reload ? "reinstalled" : "installed") : (reload ? "reloaded" : "loaded");
        String finalName = name;
        Boolean isCommandAdded = newHost.addAppCommands(s -> {
            if (!isRuleApp) {
                Messenger.m(source, Messenger.c("r Failed to add app '" + finalName + "': ", s));
            }
        });
        if (isCommandAdded == null) {
            this.removeScriptHost(source, name, false, isRuleApp);
            return false;
        }
        if (isCommandAdded.booleanValue()) {
            CommandHelper.notifyPlayersCommandsChanged(this.server);
            if (!isRuleApp) {
                Messenger.m(source, "gi " + name + " app " + action + " with /" + name + " command");
            }
        } else if (!isRuleApp) {
            Messenger.m(source, "gi " + name + " app " + action);
        }
        if (newHost.isPerUser()) {
            for (class_3222 player : source.method_9211().method_3760().method_14571()) {
                newHost.retrieveForExecution(player.method_5671(), player);
            }
        } else {
            FunctionValue onStart = newHost.getFunction("__on_start");
            if (onStart != null) {
                newHost.callNow(onStart, Collections.emptyList());
            }
        }
        CarpetProfiler.end_current_section(currentSection);
        long end = System.nanoTime();
        CarpetSettings.LOG.info("App " + name + " loaded in " + (end - start) / 1000000L + " ms");
        return true;
    }

    public boolean isInvalidCommandRoot(String appName) {
        return this.holyMoly.contains(appName);
    }

    public boolean removeScriptHost(class_2168 source, String name, boolean notifySource, boolean isRuleApp) {
        if (!this.modules.containsKey(name = name.toLowerCase(Locale.ROOT)) || !isRuleApp && !this.unloadableModules.contains(name)) {
            if (notifySource) {
                Messenger.m(source, "r No such app found: ", "wb  " + name);
            }
            return false;
        }
        this.events.removeAllHostEvents(this.modules.get(name));
        this.modules.get(name).onClose();
        this.modules.remove(name);
        ((CommandDispatcherInterface)this.server.method_3734().method_9235()).carpet$unregister(name);
        if (!isRuleApp) {
            this.unloadableModules.remove(name);
        }
        CommandHelper.notifyPlayersCommandsChanged(this.server);
        if (notifySource) {
            Messenger.m(source, "gi Removed " + name + " app");
        }
        return true;
    }

    public boolean uninstallApp(class_2168 source, String name) {
        try {
            name = name.toLowerCase(Locale.ROOT);
            Path folder = this.server.method_27050(class_5218.field_24188).resolve("scripts/trash");
            if (!Files.exists(folder, new LinkOption[0])) {
                Files.createDirectories(folder, new FileAttribute[0]);
            }
            if (!Files.exists(folder.getParent().resolve(name + ".sc"), new LinkOption[0])) {
                Messenger.m(source, "App doesn't exist in the world scripts folder, so can only be unloaded");
                return false;
            }
            this.removeScriptHost(source, name, false, false);
            Files.move(folder.getParent().resolve(name + ".sc"), folder.resolve(name + ".sc"), StandardCopyOption.REPLACE_EXISTING);
            Messenger.m(source, "gi Removed " + name + " app");
            return true;
        }
        catch (IOException exc) {
            Messenger.m(source, "rb Failed to uninstall the app");
            return false;
        }
    }

    public void tick() {
        CarpetProfiler.ProfilerToken token = CarpetProfiler.start_section(null, "Scarpet schedule", CarpetProfiler.TYPE.GENERAL);
        this.events.handleEvents.getWhileDisabled(() -> {
            this.events.tick();
            return null;
        });
        CarpetProfiler.end_current_section(token);
        token = CarpetProfiler.start_section(null, "Scarpet app data", CarpetProfiler.TYPE.GENERAL);
        for (CarpetScriptHost host : this.modules.values()) {
            host.tick();
        }
        CarpetProfiler.end_current_section(token);
    }

    public void onClose() {
        CarpetEventServer.Event.SHUTDOWN.onTick();
        for (CarpetScriptHost host : this.modules.values()) {
            host.onClose();
            this.events.removeAllHostEvents(host);
        }
    }

    public void onPlayerJoin(class_3222 player) {
        this.modules.values().forEach(h -> {
            if (h.isPerUser()) {
                try {
                    h.retrieveOwnForExecution(player.method_5671());
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
        });
    }

    public void reload(MinecraftServer server) {
        HashMap<String, TransferData> apps = new HashMap<String, TransferData>();
        this.modules.forEach((s, h) -> apps.put((String)s, new TransferData((CarpetScriptHost)h)));
        apps.keySet().forEach(s -> this.removeScriptHost(server.method_3739(), (String)s, false, false));
        CarpetEventServer.Event.clearAllBuiltinEvents();
        this.init();
        apps.forEach((s, data) -> this.addScriptHost(server.method_3739(), (String)s, data.commandValidator, data.perUser, false, data.isRuleApp, null));
    }

    public void reAddCommands() {
        this.modules.values().forEach(host -> host.addAppCommands(s -> {}));
    }

    public static void parseFunctionClasses() {
        ExpressionException.prepareForDoom();
        AnnotationParser.parseFunctionClass(Arithmetic.class);
        AnnotationParser.parseFunctionClass(ControlFlow.class);
        AnnotationParser.parseFunctionClass(DataStructures.class);
        AnnotationParser.parseFunctionClass(Functions.class);
        AnnotationParser.parseFunctionClass(Loops.class);
        AnnotationParser.parseFunctionClass(Sys.class);
        AnnotationParser.parseFunctionClass(Threading.class);
        AnnotationParser.parseFunctionClass(Auxiliary.class);
        AnnotationParser.parseFunctionClass(BlockIterators.class);
        AnnotationParser.parseFunctionClass(Entities.class);
        AnnotationParser.parseFunctionClass(Inventories.class);
        AnnotationParser.parseFunctionClass(Scoreboards.class);
        AnnotationParser.parseFunctionClass(Threading.class);
        AnnotationParser.parseFunctionClass(WorldAccess.class);
    }

    static {
        CarpetScriptServer.registerBuiltInApp(Module.carpetNative("camera", false));
        CarpetScriptServer.registerBuiltInApp(Module.carpetNative("overlay", false));
        CarpetScriptServer.registerBuiltInApp(Module.carpetNative("event_test", false));
        CarpetScriptServer.registerBuiltInApp(Module.carpetNative("stats_test", false));
        CarpetScriptServer.registerBuiltInApp(Module.carpetNative("math", true));
        CarpetScriptServer.registerBuiltInApp(Module.carpetNative("chunk_display", false));
        CarpetScriptServer.registerBuiltInApp(Module.carpetNative("ai_tracker", false));
        CarpetScriptServer.registerBuiltInApp(Module.carpetNative("draw_beta", false));
        CarpetScriptServer.registerBuiltInApp(Module.carpetNative("shapes", true));
        CarpetScriptServer.registerBuiltInApp(Module.carpetNative("distance_beta", false));
    }

    private record TransferData(boolean perUser, Predicate<class_2168> commandValidator, boolean isRuleApp) {
        private TransferData(CarpetScriptHost host) {
            this(host.perUser, host.commandValidator, host.isRuleApp);
        }
    }
}

